/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.arithmetics.FullBigFractionArithmetic;
import moze_intel.projecte.emc.collector.IExtendedMappingCollector;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.json.NSSFake;
import moze_intel.projecte.emc.json.NSSFluid;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NSSOreDictionary;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FluidMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final List<Pair<NormalizedSimpleStack, FluidStack>> melting = new ArrayList<Pair<NormalizedSimpleStack, FluidStack>>();

    private static void addMelting(String odName, String fluidName, int amount) {
        FluidMapper.addMelting(NSSOreDictionary.create(odName), fluidName, amount);
    }

    private static void addMelting(Item item, String fluidName, int amount) {
        FluidMapper.addMelting(NSSItem.create(item), fluidName, amount);
    }

    private static void addMelting(Block block, String fluidName, int amount) {
        FluidMapper.addMelting(NSSItem.create(block), fluidName, amount);
    }

    private static void addMelting(NormalizedSimpleStack stack, String fluidName, int amount) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid != null) {
            melting.add((Pair<NormalizedSimpleStack, FluidStack>)Pair.of((Object)stack, (Object)new FluidStack(fluid, amount)));
        } else {
            PECore.LOGGER.warn("Can not get Fluid '{}'", (Object)fluidName);
        }
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, Configuration config) {
        mapper.setValueBefore(NSSFluid.create(FluidRegistry.WATER), Long.MIN_VALUE);
        mapper.addConversion(1000, NSSFluid.create(FluidRegistry.LAVA), Collections.singletonList(NSSItem.create(Blocks.field_150343_Z)));
        NormalizedSimpleStack fakeMilkFluid = NSSFake.create("fakeMilkFluid");
        mapper.setValueBefore(fakeMilkFluid, 16L);
        mapper.addConversion(1, NSSItem.create(Items.field_151117_aB), Arrays.asList(NSSItem.create(Items.field_151133_ar), fakeMilkFluid));
        Fluid milkFluid = FluidRegistry.getFluid((String)"milk");
        if (milkFluid != null) {
            mapper.addConversion(1000, NSSFluid.create(milkFluid), Collections.singletonList(fakeMilkFluid));
        }
        if (!(mapper instanceof IExtendedMappingCollector)) {
            throw new RuntimeException("Cannot add Extended Fluid Mappings to mapper!");
        }
        IExtendedMappingCollector emapper = (IExtendedMappingCollector)mapper;
        FullBigFractionArithmetic fluidArithmetic = new FullBigFractionArithmetic();
        for (Pair<NormalizedSimpleStack, FluidStack> pair : melting) {
            emapper.addConversion(((FluidStack)pair.getValue()).amount, NSSFluid.create(((FluidStack)pair.getValue()).getFluid()), Collections.singletonList(pair.getKey()), fluidArithmetic);
        }
        mapper.addConversion(1, NSSItem.create(Items.field_151131_as), (Map<NormalizedSimpleStack, Integer>)ImmutableMap.of((Object)NSSItem.create(Items.field_151133_ar), (Object)1, (Object)NSSFluid.create(FluidRegistry.WATER), (Object)1000));
        mapper.addConversion(1, NSSItem.create(Items.field_151129_at), (Map<NormalizedSimpleStack, Integer>)ImmutableMap.of((Object)NSSItem.create(Items.field_151133_ar), (Object)1, (Object)NSSFluid.create(FluidRegistry.LAVA), (Object)1000));
        if (milkFluid != null) {
            mapper.addConversion(1, NSSItem.create(Items.field_151117_aB), (Map<NormalizedSimpleStack, Integer>)ImmutableMap.of((Object)NSSItem.create(Items.field_151133_ar), (Object)1, (Object)NSSFluid.create(milkFluid), (Object)1000));
        }
    }

    @Override
    public String getName() {
        return "FluidMapper";
    }

    @Override
    public String getDescription() {
        return "Adds Conversions for fluid container items and fluids.";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    static {
        FluidMapper.addMelting(Blocks.field_150343_Z, "obisidan.molten", 288);
        FluidMapper.addMelting(Blocks.field_150359_w, "glass.molten", 1000);
        FluidMapper.addMelting(Blocks.field_150410_aZ, "glass.molten", 250);
        FluidMapper.addMelting(Items.field_151079_bi, "ender", 250);
        FluidMapper.addMelting("ingotIron", "iron.molten", 144);
        FluidMapper.addMelting("ingotGold", "gold.molten", 144);
        FluidMapper.addMelting("ingotCopper", "copper.molten", 144);
        FluidMapper.addMelting("ingotTin", "tin.molten", 144);
        FluidMapper.addMelting("ingotSilver", "silver.molten", 144);
        FluidMapper.addMelting("ingotLead", "lead.molten", 144);
        FluidMapper.addMelting("ingotNickel", "nickel.molten", 144);
        FluidMapper.addMelting("ingotAluminum", "aluminum.molten", 144);
        FluidMapper.addMelting("ingotArdite", "ardite.molten", 144);
        FluidMapper.addMelting("ingotCobalt", "cobalt.molten", 144);
        FluidMapper.addMelting("ingotPlatinum", "platinum.molten", 144);
        FluidMapper.addMelting("ingotObsidian", "obsidian.molten", 144);
        FluidMapper.addMelting("ingotElectrum", "electrum.molten", 144);
        FluidMapper.addMelting("ingotInvar", "invar.molten", 144);
        FluidMapper.addMelting("ingotSignalum", "signalum.molten", 144);
        FluidMapper.addMelting("ingotLumium", "lumium.molten", 144);
        FluidMapper.addMelting("ingotEnderium", "enderium.molten", 144);
        FluidMapper.addMelting("ingotMithril", "mithril.molten", 144);
        FluidMapper.addMelting("ingotBronze", "bronze.molten", 144);
        FluidMapper.addMelting("ingotAluminumBrass", "aluminumbrass.molten", 144);
        FluidMapper.addMelting("ingotManyullyn", "manyullyn.molten", 144);
        FluidMapper.addMelting("ingotAlumite", "alumite.molten", 144);
        FluidMapper.addMelting("gemEmerald", "emerald.liquid", 640);
        FluidMapper.addMelting("dustRedstone", "redstone", 100);
        FluidMapper.addMelting("dustGlowstone", "glowstone", 250);
        FluidMapper.addMelting("dustCryotheum", "cryotheum", 100);
        FluidMapper.addMelting("dustPryotheum", "pryotheum", 100);
    }
}

